import sys,os.path

MSG_INTERRUPTED = 'break from keyboard'
MSG_NOT_A_DIR = '"%s" is not a valid directory argument'
MSG_BAD_ARG = 'invalid argument(s) : %s'
MSG_CONFIRM = '>> please confirm (y/N) I must migrate this directory : %s'
MSG_REVERSE = 'warning : reverse migration, the bypass function will be removed if scripts migration, or the documents will be written on file system if documents migration'
MSG_DRY = 'NB : this is a dry run, I am just showing what could happen'
MSG_SO_LONG = 'nothing was done, see you later'
MSG_CHECKING = '-- checking %s'
MSG_CHECK_CFG_FILE = '-- checking configuration file %s'
MSG_CHECK_DOC_PATH = '-- checking documents path %s'
MSG_ONLY_MYSQL = 'only mysql database type accepted (%s found)'
MSG_INSTALL_MYSQL = 'please install mysql connector (apt install python3-pip ; pip3 install mysql-connector-python)'
MSG_CHECK_DB_CONNECTION = '-- checking connection on database %(dolibarr_main_db_name)s'
MSG_CONNECTED = 'connected on database %(dolibarr_main_db_name)s, reading documents information'
MSG_READING_DIR = 'reading documents directory'
MSG_INFO_DOCS = '%s documents referenced in the database, thumbs, photos and others included (without .cache)'
MSG_STARTING = '-- migrating %s'
MSG_FINISHED_OK = 'migration success (%s files migrated, %s changes ; as expected)'
MSG_FINISHED_OK_DRY = 'migration should success (%s files, %s changes ; would migrate as expected)'
MSG_FINISHED_KO = 'migration not done as expected (%s files, %s changes ; migrated but %s/%s expected)'
MSG_FINISHED_KO_DRY = 'migration should not act as expected (%s files, %s changes ; would migrate but %s/%s expected)'
MGS_VERSION_KO = 'version Dolibarr (%s) not found as expected'
MSG_VERSION_OK = 'version Dolibarr %s found at the right place'
MGS_NO_CFG = 'configuration file %s not found'
MSG_CFG_OK = 'configuration file %s is good'
MSG_CFG_OK_UPDATE = 'configuration file %s is good and will be updated'
DOL_ROOT_VAR = '$dolibarr_main_data_root'
MGS_NO_DOL_VAR = 'variable %s not found in %s'
MGS_NO_DOC_ROOT = 'directory %s not found '
MGS_DOC_ROOT_OK = 'directory %s exists (must be writable, I did not check it)'
MGS_DOC_ROOT_OK_FOR_READ = 'directory %s exists'
MSG_SRCS_CHECK = '-- checking source files referenced in %s'
MSG_SRCS_OK = 'source files referenced in %s are good'
MSG_SRCS_KO = 'some source file(s) referenced in %s are not OK'
MSG_UPDATE_CFG_FILE = '-- updating configuration file'
MSG_SRCS_UPDATE = '-- updating source files referenced in %s'
MGS_INVALID_FILE = 'missing file %s'
MGS_INVALID_CMD = 'invalid command'
MSG_FINISHED_DATA_OK = '''documents migration done, you can move some %s subdirectories elsewhere to keep them safe,
but please don't move the following (because Dolibarr need them to work properly) :
    /api/temp
    dolibarr.log
    install.lock'''
MSG_FINISHED_DATA_KO = 'documents migration not done as expected'
MSG_FINISHED_DATA_OK_DRY = 'documents migration should act as expected'
MSG_FINISHED_DATA_KO_DRY = 'documents migration should not act as expected'
MSG_FINISHED_DATA_REVERSE_OK = 'documents REVERSE migration done'
MSG_FINISHED_DATA_REVERSE_KO = 'documents REVERSE migration not done as expected'
MSG_FINISHED_DATA_REVERSE_OK_DRY = 'documents REVERSE migration should act as expected'
MSG_FINISHED_DATA_REVERSE_KO_DRY = 'documents REVERSE migration should not act as expected'
MSG_CREATE_DOCUMENTS = '-- migrating documents'
MSG_CREATE_DIRECTORIES = '-- creating directories'
MSG_ADVISE = '''take care about access rights of your documents ! If www-data is your web server user, I suggest :
    chown -R www-data:www-data %(docRootPath)s
    chmod u+w -R %(docRootPath)s
you should also clean up your database %(dolibarr_main_db_name)s :
    drop table %(dolibarr_main_db_prefix)sdoc_directory;
    drop table %(dolibarr_main_db_prefix)sdoc_data;'''

FILE_BYPASS_PHP = 'filebypass.php'
MSG_COPY_BYPASS_FILE = '-- copying %s' % FILE_BYPASS_PHP
MSG_REMOVE_BYPASS_FILE = '-- removing %s' % FILE_BYPASS_PHP
DOL_VERSIONS_INFOS = (
    # in filefunc.inc.php : text 1, text 2, line number ; number of files to migrate, number of changes
    ('DOL_VERSION', '16.0.5', 36, 574, 3558),
    ('DOL_VERSION', '17.0.0', 36, 684, 3658),
)
CFG_DOC_DB_STRING = '''define('DOC_DB',true);'''
DOC_DB_DIR = os.path.join('docdb','install')

class DocDBcommon:

    DOC_TXT = 'Common class for DocDB migration scripts'

    def init(self):
        '''Arguments parsing'''

        self.help = False
        self.dryRun = False
        self.listDoc = False
        self.phpDir = ''
        self.reverse = False
        self.dolibarrDir = ''
        self.argsOk = True
        for argv in sys.argv[1:]:
            wArg = argv.lower()
            if wArg == '--help':
                self.help = True
            elif wArg == '--dry-run':
                self.dryRun = True
            elif wArg == '--list-doc':
                self.listDoc = True
            elif wArg.startswith('--phpdir='):
                try:
                    self.phpDir = argv.split('=')[-1]
                except:
                    txt = MSG_BAD_ARG % wArg
                    print(txt)
            elif wArg == '--reverse':
                self.reverse = True
            elif wArg.startswith('--dolibarrdir='):
                try:
                    self.dolibarrDir = argv.split('=')[-1]
                except:
                    txt = MSG_BAD_ARG % wArg
                    print(txt)
            else:
                print(MSG_BAD_ARG % wArg)
                self.argsOk = False
        if self.help or not self.dolibarrDir or not self.argsOk:
            print(DocDBcommon.DOC_TXT)
            sys.exit()

    def confirm(self):
        '''User confirmation'''

        print(MSG_CONFIRM % self.dolibarrDir)
        if self.reverse:
            print(MSG_REVERSE)
        if self.dryRun:
            print(MSG_DRY)
        answer = input()
        if answer.lower() not in ('yes','y'):
            print(MSG_SO_LONG)
            sys.exit()
