# docDB pour [DOLIBARR ERP CRM](https://www.dolibarr.org)

Dolibarr offre une GED (gestion électronique de documents) intégrée.<br>
Ces documents sont téléchargés par les utilisateurs sur le système de fichiers du serveur. Certains documents sont générés comme par exemple les factures, stockées elles aussi dans la GED (la variable <code>$dolibarr_main_data_root</code> du fichier de configuration indique l'emplacement des documents, <code>%dolibarr_main_data_root%</code> dans le cas présent).<br>
Par ailleurs, les données de gestion sont localisées dans une base de données (<code>%dolibarr_main_db_name%</code> en l'occurence). On parle ici de toutes les données des formulaires : numéros des facture, noms des clients, montants, libellés, etc.<br>
<strong>Le module docDB permet de stocker les documents dans la base de données, plutôt que d'utiliser le système de fichiers du serveur.</strong>

#### Pourquoi faire ?
Le fait d'utiliser deux systèmes différents fonctionne très bien mais offre plusieurs inconvénients.<br>
D'abord, il implique deux gestions techniques. À chaque fois que la question des données se pose, Le technicien chargé de l'exploitation doit y penser deux fois, selon deux aspects différents. Doit-il intervenir à propos des documents ? Que faut-il faire de la base de données ? C'est le cas lors de la mise en place et de la gestion des sauvegardes et des restaurations. C'est aussi le cas pour toute réflexion au sujet de la sécurité.<br>
Ceci augmente de façon non négligeable le temps passé et aussi le risque d'erreur.<br>
Par ailleurs, il n'est pas vraiment possible de profiter pleinement de certaines possibilités de la base de données. Pensons notamment à la réplication, qui permet de maintenir simultanément plusieurs copies identiques d'une même base. Ou aux sauvegardes incrémentielles, beaucoup plus difficiles à réaliser et si utiles pour garantir une sécurité maximale.<br>
Également, et ceci s'adresse aux développeurs, il est plus difficile de programmer des opérations de masse concernant les documents. Elles ne s'inscrivent pas vraiment dans une logique normale de programmation de base de données, et la double réflexion s'impose à chaque fois, ce qui augmente la quantité de travail de programmation et réduit fatalement la faisabilité des nouvelles fonctions à développer.<br>
Enfin, l'aspect transactionnel. Quand vous faites une série de requêtes et de mise-à-jour sur une base sql, elles s'inscrivent dans ce qu'on appelle une transaction. Cette transaction vous garantit que toutes ces requêtes et mises-à-jour seront effectuées en une fois, ou pas du tout. Autrement dit, votre base reste cohérente quoi qu'il arrive en cas d'échec d'un programme ou d'un matériel. Dans notre cas de double gestion technique, ceci peut ne pas être complètement effectif. On peut très bien imaginer des choses assez désagréables comme une sauvegarde pas tout-à-fait complète, ou un ensemble de données pas tout-à-fait synchronisé. Dans la réalité de Dolibarr, le cas devrait se produire très rarement, mais l'idée n'est quand même pas très confortable.<br>
L'intérêt du module docDB est de permettre justement que les documents soient stockés dans la base avec le reste des autres données.<br>
Transactionnel, réplication, sauvegardes incrémentielles, tout ceci devient plus facile à réaliser.<br>

#### Pourquoi ne pas faire ?
Si vous êtes habitués à Dolibarr et que le système de gestion des documents vous convient, ou que vous n'utilisez pas la GED, si toutes vos procédures sont bien rodées, si la perspective de données désynchronisées n'a pas d'importance pour vous, et si vous n'avez pas une minute à passer pour une opération qui n'apportera pas de plus-value apparente, alors ne lisez pas plus loin !<br>
Si vous avez un très gros volume de documents (plusieurs dizaines de gigas, ou plus), alors il faut peser le pour et le contre car leur migration    prendra évidemment un peu de temps. Pensez également que vous devrez ré-évaluer les espaces disques.<br>
Enfin, l'utilisation du module nécessite une adaptation : vos procédures de sauvegarde doivent probablement être revues, ce qui peut représenter un travail significatif.

#### Comment faire (installation) ?
L'opération de migration est assez simple et rapide. Cela dépend évidemment du volume de documents à convertir, mais comptez qu'un giga-octets de fichiers ne prendra guère plus de quelques minutes. Le temps nécessaire en fait pour lire et copier ailleurs. Voyez la <a href="/custom/docdb/install-fr_FR.html">notice d'installation</a> fourni avec le module.


#### Et les performances ?
Il n'y a pas de différence visible entre les deux systèmes dans des conditions de fonctionnement équivalentes.<br>
Ceci étant, suivant la configuration du serveur, on peut obtenir jusqu'à dix pour cent de temps de réponse en plus au moment particulier ou un document est téléchargé dans l'application par l'utilisateur. Ceci est dû au fait que PHP (le langage utilisé pour développer Dolibarr) stocke les documents téléchargés dans un dossier temporaire, ce qui impose au module docDB de relire ce fichier pour le charger dans la base au lieu de simplement le déplacer s'il devait être stocké sur le système de fichiers, comme dans le cas standard. C'est un point très théorique : disons qu'au lieu de mettre cinq centièmes de seconde, l'opération en prend éventuellement six...<br>
Pour tout ce qui est lecture des documents, génération des pdf, suppression, changement de nom, aucune différence de temps de réponse ; c'est pareil avec ou sans docDB.<br>
Précisons que le temps de transfert du document sur le réseau, ainsi que celui de son affichage, ne sont évidemment pas impactés.<br>
Pour finir avec ce sujet, il y a une vieille légende qui a la peau dure : c'est que MySQL (aujourd'hui remplacé par MariaDB) ne gère pas bien les grands objets binaires (les documents). Ceci a sans doute existé dans les premières versions au début de ce siècle, mais ce n'est plus du tout le cas depuis bien longtemps ! J'ai en mémoire une application en 2012 qui gérait 250 giga-octets de documents et qui offrait des performances excellentes.

## Principe de fonctionnement
Si vous souhaitez utiliser ce module, il n'est pas inutile d'en comprendre les rouages internes.<br>
Un coup d'oeil sur la <a href="/custom/docdb/doc/documentation-fr_FR.html">documentation</a> devrait satisfaire votre curiosité.

## Licence
La licence est la GPL. Voyez le fichier <a href="/custom/docdb/COPYING">COPYING</a> pour plus de détails.<br>