# docDB para [DOLIBARR ERP CRM](https://www.dolibarr.org)

Dolibarr ofrece una GED (gestión electrónica de documentos) integrada.<br>
Estos documentos son cargados por los usuarios en el sistema de archivos del servidor. Algunos documentos son generados, como por ejemplo las facturas, que también se almacenan en la GED (la variable <code>$dolibarr_main_data_root</code> en el archivo de configuración indica la ubicación de los documentos, <code>%dolibarr_main_data_root%</code> en este caso).<br>
Además, los datos de gestión se encuentran en una base de datos (<code>%dolibarr_main_db_name%</code> en este caso). Esto incluye todos los datos de los formularios: números de factura, nombres de clientes, montos, descripciones, etc.<br>
<strong>El módulo docDB permite almacenar los documentos en la base de datos en lugar de utilizar el sistema de archivos del servidor.</strong>

#### ¿Por qué hacerlo?

Utilizar dos sistemas diferentes funciona bien, pero tiene varias desventajas.<br>
En primer lugar, implica dos gestiones técnicas. Cada vez que surge la cuestión de los datos, el técnico encargado de la operación debe pensar dos veces, desde dos aspectos diferentes. ¿Debería intervenir con respecto a los documentos? ¿Qué se debe hacer con la base de datos? Esto ocurre durante la implementación y gestión de copias de seguridad y restauraciones. También sucede cuando se reflexiona sobre la seguridad.<br>
Esto aumenta significativamente el tiempo dedicado y también el riesgo de errores.<br>
Además, no es realmente posible aprovechar al máximo algunas capacidades de la base de datos. Pensemos en la replicación, que permite mantener simultáneamente varias copias idénticas de una misma base. O en las copias de seguridad incrementales, que son mucho más difíciles de realizar pero muy útiles para garantizar una seguridad máxima.<br>
También, y esto se dirige a los desarrolladores, es más difícil programar operaciones masivas relacionadas con los documentos. No se ajustan realmente a la lógica normal de programación de bases de datos, y se requiere una doble reflexión cada vez, lo que aumenta la cantidad de trabajo de programación y reduce inevitablemente la viabilidad de las nuevas funciones a desarrollar.<br>
Por último, está el aspecto transaccional. Cuando se realizan una serie de consultas y actualizaciones en una base de datos SQL, se registran en lo que se llama una transacción. Esta transacción garantiza que todas esas consultas y actualizaciones se realicen de una vez o no se realicen en absoluto. En otras palabras, su base de datos permanece coherente pase lo que pase en caso de fallo de un programa o de un hardware. En nuestro caso de doble gestión técnica, esto puede no ser completamente efectivo. Se pueden imaginar situaciones desagradables como una copia de seguridad que no esté completamente completa, o un conjunto de datos que no esté completamente sincronizado. En la realidad de Dolibarr, este caso debería ocurrir muy raramente, pero la idea aún así no es muy cómoda.<br>
El interés del módulo docDB es permitir precisamente que los documentos se almacenen en la base de datos junto con el resto de los datos.<br>
Las transacciones, la replicación, las copias de seguridad incrementales, todo esto se vuelve más fácil de realizar.<br>

#### ¿Por qué no hacerlo?

Si estás acostumbrado a Dolibarr y el sistema de gestión de documentos te conviene, o si no utilizas la GED, si todas tus procedimientos están bien establecidos, si la perspectiva de datos desincronizados no es importante para ti y si no tienes ni un minuto para dedicar a una operación que no aportará un valor agregado aparente, ¡entonces no sigas leyendo!<br>
Si tienes un volumen muy grande de documentos (varias decenas de gigabytes o más), entonces debes sopesar los pros y los contras, ya que su migración tomará obviamente un poco de tiempo. También debes tener en cuenta que tendrás que reevaluar los espacios en disco.<br>
Por último, el uso del módulo requiere adaptación: probablemente tendrás que revisar tus procedimientos de copia de seguridad, lo que puede representar un trabajo significativo.

#### ¿Cómo hacerlo (instalación)?

La operación de migración es bastante simple y rápida. Esto depende, obviamente, del volumen de documentos que se deben convertir, pero ten en cuenta que un gigabyte de archivos no tomará más que unos pocos minutos. El tiempo necesario es principalmente para leer y copiar en otro lugar. Consulta las instrucciones de instalación proporcionadas con el módulo en este enlace: <a href="/custom/docdb/install-es_ES.html">Guía de instalación</a>.

#### ¿Y el rendimiento?

No hay diferencia visible entre los dos sistemas en condiciones de funcionamiento equivalentes.<br>
Dicho esto, dependiendo de la configuración del servidor, se puede obtener hasta un diez por ciento más de tiempo de respuesta en el momento específico en que un documento es descargado en la aplicación por el usuario. Esto se debe a que PHP (el lenguaje utilizado para desarrollar Dolibarr) almacena los documentos descargados en una carpeta temporal, lo que obliga al módulo docDB a leer nuevamente ese archivo para cargarlo en la base de datos en lugar de simplemente moverlo si se hubiera almacenado en el sistema de archivos, como en el caso estándar. Este es un punto muy teórico: digamos que en lugar de tomar cinco centésimas de segundo, la operación posiblemente tome seis...<br>
En cuanto a la lectura de documentos, generación de PDF, eliminación, cambio de nombre, no hay diferencia en el tiempo de respuesta; es igual con o sin docDB.<br>
Es importante mencionar que el tiempo de transferencia del documento a través de la red, así como su visualización, no se ven afectados.<br>
Para concluir este tema, hay una vieja leyenda que perdura: que MySQL (ahora reemplazado por MariaDB) no maneja bien los objetos binarios grandes (los documentos). Esto pudo haber sido cierto en las primeras versiones a principios de este siglo, pero ya no es el caso desde hace mucho tiempo. Tengo en mente una aplicación en 2012 que gestionaba 250 gigabytes de documentos y ofrecía un rendimiento excelente.

## Principio de funcionamiento

Si deseas utilizar este módulo, no está de más entender cómo funciona internamente.<br>
Un vistazo a la <a href="/custom/docdb/doc/documentation-es_ES.html">documentación</a> debería satisfacer tu curiosidad.

## Licencia

La licencia esta la GPL. Consulta el archivo <a href="/custom/docdb/COPYING">COPYING</a> para obtener más detalles.