# docDB for [DOLIBARR ERP CRM](https://www.dolibarr.org)

Dolibarr offers an Electronic Document Management system (EDM).<br>
These documents are uploaded by users to the server's file system. Some documents, such as invoices, are generated and stored within the EDM (the <code>$dolibarr_main_data_root</code> variable in the configuration file indicates the location of the documents, <code>%dolibarr_main_data_root%</code> in this case).<br>
Furthermore, the management data is stored in a database (<code>%dolibarr_main_db_name%</code> in this case). This includes all form data: invoice numbers, customer names, amounts, descriptions, etc.<br>
<strong>The docDB module allows storing the documents in the database instead of using the server's file system.</strong>


#### Why do it ?
Using two different systems works fine but has several disadvantages.<br>
Firstly, it involves managing two technical aspects. Every time data-related issues arise, the operations technician needs to consider both aspects. Should they handle the documents? What needs to be done with the database? This applies during setup, backup and restore procedures, and also when considering security measures.<br>
This significantly increases the time spent and the risk of errors.<br>
Moreover, it is not possible to fully leverage certain database capabilities. Think of replication, which allows maintaining multiple identical copies of the same database simultaneously. Also, incremental backups are much more challenging to perform, yet they are crucial for ensuring maximum security.<br>
Additionally, for developers, it becomes more difficult to program bulk operations involving documents. These operations do not fit well into the normal logic of database programming, and each time requires dual consideration, increasing programming workload and inevitably reducing the feasibility of developing new functions.<br>
Finally, there is the transactional aspect. When you execute a series of queries and updates on an SQL database, they are part of what we call a transaction. This transaction ensures that all these queries and updates are either performed entirely or not at all. In other words, your database remains consistent regardless of program or hardware failures. However, in our case of dual technical management, this may not be fully effective. It is conceivable to encounter unpleasant situations such as an incomplete backup or a set of unsynchronized data. In Dolibarr's reality, such cases should occur very rarely, but the idea is still uncomfortable.<br>
The advantage of the docDB module is precisely to store documents in the database along with other data.<br>
Transactional support, replication, and incremental backups all become easier to achieve.<br>

#### Why not do it ?

If you are accustomed to Dolibarr and the document management system suits you, or if you don't use the EDM, if all your procedures are well established, if the prospect of desynchronized data is not important to you, and if you don't have a minute to spare for an operation that won't bring apparent added value, then don't read any further!<br>
If you have a very large volume of documents (several tens of gigabytes or more), then you need to weigh the pros and cons because their migration will obviously take some time. Also, consider that you will need to reassess your disk space requirements.<br>
Lastly, using the module requires adaptation: your backup procedures will likely need to be revised, which can represent a significant amount of work.<br>


#### How to do it (installation) ?

The migration process is quite simple and quick. It obviously depends on the volume of documents to convert, but expect that one gigabyte of files will take no more than a few minutes. The time needed is essentially to read and copy elsewhere. Refer to the <a href="/custom/docdb/install-en_EN.html">installation guide</a> provided with the module.


#### And what about performance ?

There is no visible difference between the two systems under equivalent operating conditions.<br>
However, depending on the server configuration, you may experience up to ten percent longer response times at the specific moment a document is downloaded in the application by the user. This is because PHP (the language used to develop Dolibarr) stores downloaded documents in a temporary folder, which requires the docDB module to read the file to load it into the database instead of simply moving it if it were stored in the file system, as in the standard case. This is a very theoretical point: let's say instead of taking five hundredths of a second, the operation might take six...<br>
For all document reading, PDF generation, deletion, and renaming, there is no difference in response time; it's the same with or without docDB.<br>
Please note that the document transfer time over the network, as well as its display time, are not affected.<br>
To conclude this topic, there is an enduring old legend : that MySQL (now replaced by MariaDB) doesn't handle large binary objects (documents) well. This may have been the case in the early versions at the beginning of this century, but it has not been the case for a long time ! I remember an application in 2012 that managed 250 gigabytes of documents and offered excellent performance.


## Operating principle

If you wish to use this module, it is useful to understand its internal workings.<br>
A look at the <a href="/custom/docdb/doc/documentation-en_EN.html">documentation</a> should satisfy your curiosity.


## License

DocDB is licensed under GPL. Refer to the file <a href="/custom/docdb/COPYING">COPYING</a> for more details.