<?php
/* global variables */

// lists and ids
$openDirectoriesLst = array();
$freadIndexesLst = array();
// usefull for debugging
$useByPass = true;

/* utilities */

function bypass_log($funcpref, $func, $prog, $pathName, $return) {
    if (doc_in_db($pathName)) {
        $indic = '++';
    } else {
        $indic = '--';
    }
    $w1 = str_replace(DOL_DATA_ROOT,'',$pathName);
    $w2 = $return;
    if (gettype($return) == 'array') {
        $w2 ='';
        foreach ($return as $row) {
            $w2 = $w2 . "|" . $row;
        }        
    }
    dol_syslog("DOC_DB $indic $funcpref$func $prog $w1 [$w2]", LOG_DEBUG);
}
function doc_in_db($pathName) {
    if (defined('DOC_DB') && DOC_DB && gettype($pathName) == 'string' && strpos($pathName,DOL_DATA_ROOT) !== false) {
        return true;
    }
    return false;
}
// $escape flag usefull only for sql requests, buggy otherwise
function get_doc_dir_suffix($pathName, $escape=true) {
    global $db;
    $w = str_replace(DOL_DATA_ROOT,'',$pathName);
    $w = str_replace('//','/',$w);
    $w = forceUtf8($w);
    if ($escape) {
        $w = $db->escape($w);
    }
    return $w;
}
/* the painfull stuff :
forceUtf8 eventually wrong. It was due to a false bug, added because of a wrong charset in database creation during the tests
To emulate properly the file system behaviour (where É is different from E), 
    the table must be created with DEFAULT CHARSET=utf8 COLLATE=utf8_bin
    and NOT DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci (as with dolibarr default)
    Can be updated with : alter table llx_doc_data convert to character set utf8 collate utf8_bin;
    and reversed with : alter table llx_doc_data convert to character set utf8mb4 collate utf8mb4_general_ci;
NB : on windows, diacritics characters management don't fully work
*/
// switch back to utf8 (stored in db, we don't care of old windows file system encoding)
function forceUtf8($filename) {
    // if (mb_check_encoding($filename,'ISO-8859-1')) : do not work
    //     if (PHP_OS != 'Linux') {
    //         $filename = iconv("ISO-8859-1","UTF-8//TRANSLIT",$filename);
    //     }
    return $filename;
}
function get_max_packet_size() {
    global $db;
    $resql = $db->query("show variables like 'max_allowed_packet'");
    $obj = $db->fetch_object($resql);
    return $obj->Value;
}

/* 
fonctions bypass
see PHP documentation for arguments meaning
*/

function is_dir_Bypass($filename, $prog='') {
    return is_dir_Bypass_do('', $prog, $filename);
}
function is_dir_BypassA($filename, $prog='') {
    return is_dir_Bypass_do('@', $prog, $filename);
}
function is_dir_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass; 
    if ($useByPass && doc_in_db($filename)) {
        $return = false;
        // check if referenced
        global $db;
        $w = get_doc_dir_suffix($filename);
        $pathArr = array($w,rtrim($w,'/'),rtrim($w,'\\'));
        foreach ($pathArr as $wp) {
            $wpe = $wp;
            $sql = "select rowid from ".MAIN_DB_PREFIX."doc_directory where path_name='$wpe'";
            $resql = $db->query($sql);
            if ($resql) {
                $obj = $db->fetch_object($resql);
                $rowid = $obj->rowid;
                if ($rowid) {
                    // is a directory
                    $return = true;
                    break;
                }
            }
        }
    } else {
        if ($funcpref != '@') {
            $return = is_dir($filename);
        } else {
            $return = @is_dir($filename);
        }
    }
    bypass_log($funcpref, 'isdir', $prog, $filename, $return);
    return $return;
}

function is_writable_Bypass($filename, $prog='') {
    return is_writable_Bypass_do('', $prog, $filename);
}
function is_writable_BypassA($filename, $prog='') {
    return is_writable_Bypass_do('@', $prog, $filename);
}
function is_writeable_Bypass($filename, $prog='') {
    return is_writable_Bypass_do('', $prog, $filename);
}
function is_writeable_BypassA($filename, $prog='') {
    return is_writable_Bypass_do('@', $prog, $filename);
}
function is_writable_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = is_dir_Bypass_do($funcpref, $prog, $filename);
        if (!$return) {
            $return = is_file_Bypass_do($funcpref, $prog, $filename);
        }
    } else {
        if ($funcpref != '@') {
            $return = is_writable($filename);
        } else {
            $return = @is_writable($filename);
        }
    }
    bypass_log($funcpref, 'is_writeable', $prog, $filename, $return);
    return $return;
}

function is_readable_Bypass($filename, $prog='') {
    return is_readable_Bypass_do('', $prog, $filename);
}
function is_readable_BypassA($filename, $prog='') {
    return is_readable_Bypass_do('@', $prog, $filename);
}
function is_readable_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = is_file_Bypass_do($funcpref, $prog, $filename);
    } else {
        if ($funcpref != '@') {
            $return = is_readable($filename);
        } else {
            $return = @is_readable($filename);
        }
    }
    bypass_log($funcpref, 'is_readable', $prog, $filename, $return);
    return $return;
}

function file_exists_Bypass($filename, $prog='') {
    return file_exists_Bypass_do('', $prog, $filename);
}
function file_exists_BypassA($filename, $prog='') {
    return file_exists_Bypass_do('@', $prog, $filename);
}
function file_exists_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = is_file_Bypass_do($funcpref, $prog, $filename);
        if (!$return) {
            $return = is_dir_Bypass_do($funcpref, $prog, $filename);
        }
    } else {
        if ($funcpref != '@') {
            $return = file_exists($filename);
        } else {
            $return = @file_exists($filename);
        }
    }
    bypass_log($funcpref, 'file_exists', $prog, $filename, $return);
    return $return;
}

function mkdir_Bypass($filename, $permissions = 0777, $recursive = false, $prog='') {
    return mkdir_Bypass_do('', $prog, $filename, $permissions, $recursive);
}
function mkdir_BypassA($filename, $permissions = 0777, $recursive = false, $prog='') {
    return mkdir_Bypass_do('@',$prog,$filename, $permissions, $recursive);
}
function mkdir_Bypass_do($funcpref, $prog, $filename, $permissions, $recursive) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = false;
        global $db;
        $w = get_doc_dir_suffix($filename);
        $sql = "insert into ".MAIN_DB_PREFIX."doc_directory (path_name) values ('$w')";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
    } else {
        if ($funcpref != '@') {
            $return = mkdir($filename, $permissions, $recursive);
        } else {
            $return = @mkdir($filename, $permissions, $recursive);
        }
    }
    bypass_log($funcpref, "mkdir", $prog, "$filename $permissions $recursive", $return);
    return $return;
}

function rmdir_Bypass($directory, $prog='') {
    return rmdir_Bypass_do('', $prog, $directory);
}
function rmdir_BypassA($directory, $prog='') {
    return rmdir_Bypass_do('@',$prog,$directory);
}
function rmdir_Bypass_do($funcpref, $prog, $directory) {
    global $useByPass;
    if ($useByPass && doc_in_db($directory)) {
        $return = false;
        global $db;
        $dirSuffix = rtrim(get_doc_dir_suffix($directory),'/');
        $dirSuffix = rtrim($dirSuffix,'\\');
        // delete folder itself
        $w = $dirSuffix;
        $sql = "delete from ".MAIN_DB_PREFIX."doc_directory where path_name like '$w'";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
        // delete folder children
        $w = $dirSuffix . '/%';
        $sql = "delete from ".MAIN_DB_PREFIX."doc_directory where path_name like '$w'";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
        // delete files of the folder and subfolders
        $w = $dirSuffix . '/%';
        $sql = "delete from ".MAIN_DB_PREFIX."doc_data where path_name like '$w'";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
    } else {
        if ($funcpref != '@') {
            $return = rmdir($directory);
        } else {
            $return = @rmdir($directory);
        }
    }
    bypass_log($funcpref, "rmdir", $prog, "$directory", $return);
    return $return;
}

function move_uploaded_file_Bypass($from, $to, $prog='') {
    global $useByPass;
    if ($useByPass && doc_in_db($to)) {
        global $db;
        $maxSize = get_max_packet_size();
        // set string data (as dolibarr, because 'prepare' can put some disturbing escape)
        $wTo = get_doc_dir_suffix($to);
        $sql = "insert into ".MAIN_DB_PREFIX."doc_data (path_name,filemtime) values ('$wTo',utc_timestamp())";
        $resql = $db->query($sql);
        if ($resql) {
            $rowid = $db->db->insert_id;
            // insert binary data eventually
            $exif_data = serialize(exif_read_data($from));
            $imagesize = serialize(getimagesize($from));
            $sql = "update ".MAIN_DB_PREFIX."doc_data set exif_data=?,imagesize=?,datablob=? where rowid='$rowid'";
            $stmt = $db->db->prepare($sql);
            $null = NULL;
            $stmt->bind_param('ssb',$exif_data,$imagesize,$null);
            $handle = fopen($from,"rb");
            while (!feof($handle)) {
                $stmt->send_long_data(2,fread($handle,$maxSize));
            }
            fclose($handle);
            $stmt->execute();
            $stmt->close();
        }
        $return = true;
    } else {
        $return = move_uploaded_file($from, $to);
    }
    bypass_log('', "move_uploaded_file", $prog, "$from $to", $return);
    return $return;
}

function chmod_Bypass($filename, $permissions, $prog='') {
    return chmod_Bypass_do('', $prog, $filename, $permissions);
}
function chmod_BypassA($filename, $permissions, $prog='') {
    return chmod_Bypass_do('@', $prog, $filename, $permissions);
}
function chmod_Bypass_do($funcpref, $prog, $filename, $permissions) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = true;
    } else {
        if ($funcpref != '@') {
            $return = chmod($filename, $permissions);
        } else {
            $return = @chmod($filename, $permissions);
        }
    }
    bypass_log($funcpref, "chmod", $prog, "$filename $permissions", $return);
    return $return;
}

/*
Open a directory, read and store the directories and files paths included in it
*/
function opendir_Bypass($directory, $prog='') {
    return opendir_Bypass_do('', $prog, $directory);
}
function opendir_BypassA($directory, $prog='') {
    return opendir_Bypass_do('@', $prog, $directory);
}
function opendir_Bypass_do($funcpref, $prog, $directory) {
    global $useByPass;
    if ($useByPass && doc_in_db($directory)) {
        global $db,$openDirectoriesLst;
        $fileIndex = 0;
        $filesLst = array();
        $w = get_doc_dir_suffix($directory);
        // both following requests where previously made by sql union, but this does not work with some collation option
        $sql = "select path_name from ".MAIN_DB_PREFIX."doc_directory where path_name like '$w/%' ".
            "and path_name not in (select path_name from ".MAIN_DB_PREFIX."doc_directory where path_name like '$w/%/%')";
        $resql = $db->query($sql);
        if ($resql) {
            while ($obj = $db->fetch_object($resql)) {
                array_push($filesLst,$obj->path_name);
            }
        }
        $sql = "select path_name from ".MAIN_DB_PREFIX."doc_data where path_name like '$w/%' ".
            "and path_name not in (select path_name from ".MAIN_DB_PREFIX."doc_data where path_name like '$w/%/%');";
        $resql = $db->query($sql);
        if ($resql) {
            while ($obj = $db->fetch_object($resql)) {
                array_push($filesLst,$obj->path_name);
            }
        }
        //
        $dirEntries = array($fileIndex,$filesLst);
        $handleNum = sizeof($openDirectoriesLst);
        $openDirectoriesLst[$handleNum] = $dirEntries;
        $return = "HDL$handleNum";
    } else {
        if ($funcpref != '@') {
            $return = opendir($directory);
        } else {
            $return = @opendir($directory);
        }
    }
    bypass_log($funcpref, "opendir", $prog, "$directory", $return);
    return $return;
}
function readdir_Bypass($dir_handle, $prog='') {
    return readdir_Bypass_do('', $prog, $dir_handle);
}
function readdir_BypassA($dir_handle, $prog='') {
    return readdir_Bypass_do('@', $prog, $dir_handle);
}
function readdir_Bypass_do($funcpref, $prog, $dir_handle) {
    if (is_string($dir_handle) and substr($dir_handle,0,3) == 'HDL') {
        global $openDirectoriesLst;
        $handleNum = str_replace('HDL','',$dir_handle);
        $dirEntry = $openDirectoriesLst[$handleNum];
        $fileIndex = $dirEntry[0];
        $filesLst = $dirEntry[1];
        if ($fileIndex < sizeof($filesLst)) {
            $return = basename($filesLst[$fileIndex]);
            $openDirectoriesLst[$handleNum][0] = $fileIndex + 1;
        } else {
            $return = false;
        }
    } else {
        if ($funcpref != '@') {
            $return = readdir($dir_handle);
        } else {
            $return = @readdir($dir_handle);
        }
    }
    bypass_log($funcpref, "readdir", $prog, $dir_handle, $return);
    return $return;
}
function closedir_Bypass($dir_handle, $prog='') {
    return closedir_Bypass_do('', $prog, $dir_handle);
}
function closedir_BypassA($dir_handle, $prog='') {
    return closedir_Bypass_do('@', $prog, $dir_handle);
}
function closedir_Bypass_do($funcpref, $prog, $dir_handle) {
    if (is_string($dir_handle) and substr($dir_handle,0,3) == 'HDL') {
        global $openDirectoriesLst;
        $handleNum = str_replace('HDL','',$dir_handle);
        unset($openDirectoriesLst[$handleNum]);
    } else {
        if ($funcpref != '@') {
            $return = closedir($dir_handle);
        } else {
            $return = @closedir($dir_handle);
        }
    }
    bypass_log($funcpref, "closedir", $prog, $dir_handle, $return);
    return $return;
}

function filemtime_Bypass($filename, $prog='') {
    return filemtime_Bypass_do('', $prog, $filename);
}
function filemtime_BypassA($filename, $prog='') {
    return filemtime_Bypass_do('@', $prog, $filename);
}
function filemtime_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        global $db;
        $w = get_doc_dir_suffix($filename);
        $sql = "select filemtime from ".MAIN_DB_PREFIX."doc_data where path_name='$w'";
        $resql = $db->query($sql);
        $obj = $db->fetch_object($resql);
        $return = $obj->filemtime;
    } else {
        if ($funcpref != '@') {
            $return = filemtime($filename);
        } else {
            $return = @filemtime($filename);
        }
    }
    bypass_log($funcpref, "filemtime", $prog, "$filename", $return);
    return $return;
}

function filesize_Bypass($filename, $prog='') {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        global $db;
        $w = get_doc_dir_suffix($filename);
        $sql = "select octet_length(datablob) as filesize from ".MAIN_DB_PREFIX."doc_data where path_name='$w'";
        $resql = $db->query($sql);
        $obj = $db->fetch_object($resql);
        $return = $obj->filesize;
    } else {
        $return = filesize($filename);
    }
    bypass_log('', "filesize", $prog, "$filename", $return);
    return $return;
}

function readfile_Bypass($filename, bool $use_include_path = false, $prog='') {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $data = getBlob($filename);
        echo $data;
        $return = strlen($data);
    } else {
        $return = readfile($filename, $use_include_path);
    }
    bypass_log('', "readfile", $prog, "$filename $use_include_path", $return);
    return $return;
}
function getBlob($filename) {
    global $db;
    // $db->begin();
    $w = get_doc_dir_suffix($filename);
    $sql = "select datablob from ".MAIN_DB_PREFIX."doc_data where path_name='$w'";
    $stmt = $db->db->prepare($sql);
    $stmt->execute();
    $imageString = NULL;
    $stmt->bind_result($imageString);
    while ($stmt->fetch()) {}
    $stmt->close();
    // $db->commit();
    return $imageString;
}

function is_file_Bypass($filename, $prog='') {
    return is_file_Bypass_do('', $prog, $filename);
}
function is_file_BypassA($filename, $prog='') {
    return is_file_Bypass_do('@', $prog, $filename);
}
function is_file_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = false;
        global $db;
        $w = get_doc_dir_suffix($filename);
        $sql = "select rowid from ".MAIN_DB_PREFIX."doc_data where path_name='$w'";
        $resql = $db->query($sql);
        $obj = $db->fetch_object($resql);
        $rowid = $obj->rowid;
		if ($rowid) {
            $return = true;
        }
    } else {
        if ($funcpref != '@') {
            $return = is_file($filename);
        } else {
            $return = @is_file($filename);
        }
    }
    bypass_log($funcpref, "is_file", $prog, "$filename", $return);
    return $return;
}

/* Replacing * by % is not strictly equivalent to the file system behaviour,
    but wildcards are not so much used in dolibarr documents context,
    and not any problem occured while the tests.
Another possible source of troubles is that glob_Bypass() does not read the llx_doc_directory table.
    It does not matter as the caller goal is only to read the files paths.
*/
function glob_Bypass($pattern, $flags = 0, $prog='') {
    global $useByPass;
    if ($useByPass && doc_in_db($pattern)) {
        global $db;
        $filesLst = array();
        $w = get_doc_dir_suffix($pattern);
        $w = str_replace("*",'%',$w);
        $sql = "select path_name from ".MAIN_DB_PREFIX."doc_data where path_name like '$w'";
        $resql = $db->query($sql);
        if ($resql) {
            while ($obj = $db->fetch_object($resql)) {
                array_push($filesLst,DOL_DATA_ROOT.$obj->path_name);
            }
        }
        $return = $filesLst;
    } else {
        $return = glob($pattern, $flags);
    }
    bypass_log('', "glob", $prog, "$pattern $flags", $return);
    return $return;
}

function unlink_Bypass($filename, $prog='') {
    return unlink_Bypass_do('', $prog, $filename);
}
function unlink_BypassA($filename, $prog='') {
    return unlink_Bypass_do('@', $prog, $filename);
}
function unlink_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = false;
        global $db;
        $w = get_doc_dir_suffix($filename);
        $sql = "delete from ".MAIN_DB_PREFIX."doc_data where path_name='$w'";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
    } else {
        if ($funcpref != '@') {
            $return = unlink($filename);
        } else {
            $return = @unlink($filename);
        }
    }
    bypass_log($funcpref, "unlink", $prog, "$filename", $return);
    return $return;
}

function rename_Bypass($from, $to, $prog='') {
    return rename_Bypass_do('', $prog, $from, $to);
}
function rename_BypassA($from, $to, $prog='') {
    return rename_Bypass_do('@', $prog, $from, $to);
}
function rename_Bypass_do($funcpref, $prog, $from, $to) {
    global $useByPass;
    if ($useByPass && doc_in_db($from)) {
        $return = false;
        global $db;
        // manage file names
        $wfrom = rtrim(get_doc_dir_suffix($from),'/');
        $wto = rtrim(get_doc_dir_suffix($to),'/');//
        // wildcard rename all matching directory paths
        $sql = "update ".MAIN_DB_PREFIX."doc_directory set path_name = replace(path_name,'$wfrom','$wto') where path_name like '$wfrom%'";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
        // also in files path
        $sql = "update    ".MAIN_DB_PREFIX."doc_data set path_name = replace(path_name,'$wfrom','$wto') where path_name like '$wfrom/%'";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
        // exact rename if just a file
        $sql = "update        ".MAIN_DB_PREFIX."doc_data set path_name = replace(path_name,'$wfrom','$wto') where path_name like '$wfrom'";
        $resql = $db->query($sql);
        if ($resql) {
            $return = true;
        }
    } else {
        if ($funcpref != '@') {
            $return = rename($from, $to);
        } else {
            $return = @rename($from, $to);
        }
    }
    bypass_log($funcpref, "rename", $prog, "$from $to", $return);
    return $return;
}

function realpath_Bypass($path, $prog='') {
    global $useByPass;
    if ($useByPass && doc_in_db($path)) {
        $return = $path;
    } else {
        $return = realpath($path);
    }
    bypass_log('', "realpath", $prog, $path, $return);
    return $return;
}
function realpath_BypassA($path, $prog='') {
    global $useByPass;
    if ($useByPass && doc_in_db($path)) {
        $return = $path;
    } else {
        $return = @realpath($path);
    }
    bypass_log('@', "realpath", $prog, $path, $return);
    return $return;
}

function getimagesize_Bypass($filename, $prog='') {
    return getimagesize_Bypass_do('', $prog, $filename);
}
function getimagesize_BypassA($filename, $prog='') {
    return getimagesize_Bypass_do('@', $prog, $filename);
}
function getimagesize_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        global $db;
        $w = get_doc_dir_suffix($filename);
        $sql = "select imagesize from ".MAIN_DB_PREFIX."doc_data where path_name='$w'";
        $resql = $db->query($sql);
        $obj = $db->fetch_object($resql);
        $return = unserialize($obj->imagesize);
    } else {
        if ($funcpref != '@') {
            $return = getimagesize($filename);
        } else {
            $return = @getimagesize($filename);
        }
    }
    bypass_log($funcpref, "getimagesize", $prog, $filename, $return);
    return $return;
}

function exif_read_data_Bypass($filename, $prog='') {
    return exif_read_data_Bypass_do('', $prog, $filename);
}
function exif_read_data_BypassA($filename, $prog='') {
    return exif_read_data_Bypass_do('@', $prog, $filename);
}
function exif_read_data_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        global $db;
        $w = get_doc_dir_suffix($filename);
        $sql = "select exif_data from ".MAIN_DB_PREFIX."doc_data where path_name='$w'";
        $resql = $db->query($sql);
        $obj = $db->fetch_object($resql);
        $return = unserialize($obj->exif_data);
    } else {
        if ($funcpref != '@') {
            $return = exif_read_data($filename);
        } else {
            $return = @exif_read_data($filename);
        }
    }
    bypass_log($funcpref, "exif_read_data", $prog, $filename, $return);
    return $return;
}

function imagecreatefromjpeg_Bypass($filename, $prog='') {
    return imagecreatefromjpeg_Bypass_do('', $prog, $filename);
}
function imagecreatefromjpeg_BypassA($filename, $prog='') {
    return imagecreatefromjpeg_Bypass_do('@', $prog, $filename);
}
function imagecreatefromjpeg_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = imagecreatefromstring_Bypass_do($filename);
    } else {
        if ($funcpref != '@') {
            $return = imagecreatefromjpeg($filename);
        } else {
            $return = @imagecreatefromjpeg($filename);
        }
    }
    bypass_log($funcpref, "imagecreatefromjpeg", $prog, $filename, $return);
    return $return;
}
function imagecreatefromgif_Bypass($filename, $prog='') {
    return imagecreatefromgif_Bypass_do('', $prog, $filename);
}
function imagecreatefromgif_BypassA($filename, $prog='') {
    return imagecreatefromgif_Bypass_do('@', $prog, $filename);
}
function imagecreatefromgif_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = imagecreatefromstring_Bypass_do($filename);
    } else {
        if ($funcpref != '@') {
            $return = imagecreatefromgif($filename);
        } else {
            $return = @imagecreatefromgif($filename);
        }
    }
    bypass_log($funcpref, "imagecreatefromgif", $prog, $filename, $return);
    return $return;
}
function imagecreatefrompng_Bypass($filename, $prog='') {
    return imagecreatefrompng_Bypass_do('', $prog, $filename);
}
function imagecreatefrompng_BypassA($filename, $prog='') {
    return imagecreatefrompng_Bypass_do('@', $prog, $filename);
}
function imagecreatefrompng_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = imagecreatefromstring_Bypass_do($filename);
    } else {
        if ($funcpref != '@') {
            $return = imagecreatefrompng($filename);
        } else {
            $return = @imagecreatefrompng($filename);
        }
    }
    bypass_log($funcpref, "imagecreatefrompng", $prog, $filename, $return);
    return $return;
}
function imagecreatefromwbmp_Bypass($filename, $prog='') {
    return imagecreatefromwbmp_Bypass_do('', $prog, $filename);
}
function imagecreatefromwbmp_BypassA($filename, $prog='') {
    return imagecreatefromwbmp_Bypass_do('@', $prog, $filename);
}
function imagecreatefromwbmp_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = imagecreatefromstring_Bypass_do($filename);
    } else {
        if ($funcpref != '@') {
            $return = imagecreatefromwbmp($filename);
        } else {
            $return = @imagecreatefromwbmp($filename);
        }
    }
    bypass_log($funcpref, "imagecreatefromwbmp", $prog, $filename, $return);
    return $return;
}
function imagecreatefromwebp_Bypass($filename, $prog='') {
    return imagecreatefromwebp_Bypass_do('', $prog, $filename);
}
function imagecreatefromwebp_BypassA($filename, $prog='') {
    return imagecreatefromwebp_Bypass_do('@', $prog, $filename);
}
function imagecreatefromwebp_Bypass_do($funcpref, $prog, $filename) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        $return = imagecreatefromstring_Bypass_do($filename);
    } else {
        if ($funcpref != '@') {
            $return = imagecreatefromwebp($filename);
        } else {
            $return = @imagecreatefromwebp($filename);
        }
    }
    bypass_log($funcpref, "imagecreatefromwebp", $prog, $filename, $return);
    return $return;
}
function imagecreatefromstring_Bypass_do($filename) {
    $imageData = getBlob($filename);
    return imagecreatefromstring($imageData);
}

function imagegif_Bypass($image, $filename, $quality = -1, $prog='') {
    return imageAny('imagegif', $prog, $image, $filename);
}
function imagejpeg_Bypass($image, $filename, $quality = -1, $prog='') {
    return imageAny('imagejpeg', $prog, $image, $filename, $quality);
}
function imagepng_Bypass($image, $filename, $quality = -1, $prog='') {
    return imageAny('imagepng', $prog, $image, $filename, $quality);
}
function imagewbmp_Bypass($image, $filename, $quality = -1, $prog='') {
    return imageAny('imagewbmp', $prog, $image, $filename);
}
function imageAny($imagefunc, $prog, $image, $filename, $quality = -1) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        global $db;
        // get image file into string
        ob_start();
        if ($imagefunc == 'imagegif') {
            imagegif($image);
        } else if ($imagefunc == 'imagejpeg') {
            imagejpeg($image);
        } else if ($imagefunc == 'imagepng') {
            imagepng($image);
        } else if ($imagefunc == 'imagewbmp') {
            imagewbmp($image);
        }
        $strImage = ob_get_contents();
        ob_end_clean();
        $maxSize = get_max_packet_size();
        // set string data (as dolibarr, because 'prepare' can put some disturbing escape)
        $wFilename = get_doc_dir_suffix($filename);
        $sql = "select rowid from ".MAIN_DB_PREFIX."doc_data where path_name='$wFilename'";
        $resql = $db->query($sql);
        $obj = $db->fetch_object($resql);
        $rowid = $obj->rowid;
        if (!is_null($rowid)) {
            $sql = "update ".MAIN_DB_PREFIX."doc_data set filemtime=utc_timestamp() where rowid='$rowid'";
            $resql = $db->query($sql);
        } else {
            $sql = "insert into ".MAIN_DB_PREFIX."doc_data (path_name,filemtime) ".
                "values ('$wFilename',utc_timestamp())";
            $resql = $db->query($sql);
            if ($resql) {
                $rowid = $db->db->insert_id;
            }
        }
        if (!is_null($rowid)) {
            // insert binary data eventually
            $imagesize = serialize(getimagesizefromstring($strImage));
            $sql = "update ".MAIN_DB_PREFIX."doc_data set imagesize=?,datablob=? where rowid='$rowid'";
            $stmt = $db->db->prepare($sql);
            $null = NULL;
            $stmt->bind_param('sb',$imagesize,$null);
            $stmt->send_long_data(1,$strImage);
            $stmt->execute();
            $stmt->close();
        }
        $return = true;
    } else {
        if ($imagefunc == 'imagegif') {
            $return = imagegif($image, $filename);
        } else if ($imagefunc == 'imagejpeg') {
            $return = imagejpeg($image, $filename, $quality);
        } else if ($imagefunc == 'imagepng') {
            $return = imagepng($image, $filename, $quality);
        } else if ($imagefunc == 'imagewbmp') {
            $return = imagewbmp($image, $filename);
        }
    }
    bypass_log('', $imagefunc, $prog, $filename, $return);
    return $return;
}

// In the context of Dolibarr documents, fopen, fwrite, and fclose functions
// are only used for pdf generation. As there are not images generated in that cases,
// bypass functions do not care about exif and image sizes data.
function fopen_Bypass($filename, $mode, $use_include_path = false, $prog='') {
    return fopen_Bypass_do('', $prog, $filename, $mode, $use_include_path);
}
function fopen_BypassA($filename, $mode, $use_include_path = false, $prog='') {
    return fopen_Bypass_do('@', $prog, $filename, $mode, $use_include_path);
}
function fopen_Bypass_do($funcpref, $prog, $filename, $mode, $use_include_path) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        global $db, $freadIndexesLst;
        // read rowid if exists
        $wFilename = str_replace('file://','/',$filename);
        $wFilename = get_doc_dir_suffix($wFilename);
        $sql = "select rowid from ".MAIN_DB_PREFIX."doc_data where path_name='$wFilename'";
        $resql = $db->query($sql);
        $rowid = '';
        if ($resql) {
            $obj = $db->fetch_object($resql);
            $rowid = $obj->rowid;
        }
        $readIndex = "ROWID_R_$rowid";
        // write mode ?
        if (strpos($mode,'w') !== false) {
            if ($rowid == '') {
                // assume is not an image file
                $w2 = serialize(false);
                //
                $sql = "insert into ".MAIN_DB_PREFIX."doc_data (path_name,filemtime,exif_data,imagesize) " .
                    "values ('$wFilename',utc_timestamp(),'$w2','$w2')";
                $resql = $db->query($sql);
                if ($resql) {
                    $rowid = $db->db->insert_id;
                }
            }
            $readIndex = "ROWID_W_$rowid";
        }
        $freadIndexesLst[$readIndex] = 1;
        $return = $readIndex;
    } else {
        if ($funcpref != '@') {
            $return = fopen($filename, $mode, $use_include_path);
        } else {
            $return = @fopen($filename, $mode, $use_include_path);
        }
    }
    bypass_log($funcpref, "fopen", $prog, "$filename $mode $use_include_path", $return);
    return $return;
}

function fread_Bypass($stream, $length, $prog='') {
    return fread_Bypass_do('', $prog, $stream, $length);
}
function fread_BypassA($stream, $length, $prog='') {
    return fread_Bypass_do('@', $prog, $stream, $length);
}
function fread_Bypass_do($funcpref, $prog, $stream, $length) {
    if (strpos($stream,"ROWID") !== false) {
        // get row id
        $rowid = str_replace('ROWID_R_','',$stream);
        // read document data
        global $db,$freadIndexesLst;
        $readIndex = $freadIndexesLst[$stream];
        $sql = "select substring(datablob,$readIndex,$length) from ".MAIN_DB_PREFIX."doc_data where rowid='$rowid'";
        $stmt = $db->db->prepare($sql);
        $stmt->execute();
        $imageString = NULL;
        $stmt->bind_result($imageString);
        while ($stmt->fetch()) {}
        $stmt->close();
        $freadIndexesLst[$stream] += $length;
        $return = $imageString;
        $ln = strlen($return);
    } else {
        if ($funcpref != '@') {
            $return = fread($stream, $length);
        } else {
            $return = @fread($stream, $length);
        }
    }
    bypass_log($funcpref, "fread", $prog, "$stream $ln", $return);
    return $return;
}

function fwrite_Bypass($stream, $data, $length = null, $prog='') {
    return fwrite_Bypass_do('', $prog, $stream, $data, $length);
}
function fwrite_BypassA($stream, $data, $length = null, $prog='') {
    return @fwrite_Bypass_do('@', $prog, $stream, $data, $length);
}
function fwrite_Bypass_do($funcpref, $prog, $stream, $data, $length) {
    if (strpos($stream,"ROWID") !== false) {
        // get row id
        $rowid = str_replace('ROWID_W_','',$stream);
        // insert document data
        global $db;
        $sql = "update ".MAIN_DB_PREFIX."doc_data set datablob=? where rowid='$rowid'";
        $stmt = $db->db->prepare($sql);
        $null = NULL;
        $stmt->bind_param('b',$null);
        // $stmt->send_long_data(0,$data,$length); // **** marche pô !
        $stmt->send_long_data(0,$data);
        $stmt->execute();
        $stmt->close();
        $return = true;
    } else {
        if ($funcpref != '@') {
            $return = fwrite($stream, $data);
        } else {
            $return = @fwrite($stream, $data);
        }
    }
    bypass_log($funcpref, "fwrite", $prog, "$stream $length", $return);
    return $return;
}

function fclose_Bypass($stream, $prog='') {
    fclose_Bypass_do('', $prog, $stream);
}
function fclose_BypassA($stream, $prog='') {
    fclose_Bypass_do('@', $prog, $stream);
}
function fclose_Bypass_do($funcpref, $prog, $stream) {
    if (strpos($stream,"ROWID") !== false) {
        $return = true;
    } else {
        $return = fclose($stream);
    }
    bypass_log($funcpref, "fclose", $prog, "$stream", $return);
    return $return;
}

function feof_Bypass($stream, $prog='') {
    $return = feof($stream);
    bypass_log('', "feof", $prog, $stream, $return);
    return $return;
}

function scandir_Bypass($directory, $sorting_order = SCANDIR_SORT_ASCENDING, $prog='') {
    return scandir_Bypass_do('', $prog, $directory, $sorting_order);
}
function scandir_BypassA($directory, $sorting_order = SCANDIR_SORT_ASCENDING, $prog='') {
    return scandir_Bypass_do('@', $prog, $directory, $sorting_order);
}
function scandir_Bypass_do($funcpref, $prog, $directory, $sorting_order) {
    global $useByPass;
    if ($useByPass && doc_in_db($directory)) {
        global $db;
        $filesLst = array('.','..');
        // look for "files and non empty directories" union "empty directories"
        $dirSuffix = rtrim(get_doc_dir_suffix($directory),'/');
        $sql = "select path_name from ".MAIN_DB_PREFIX."doc_data where path_name like '$dirSuffix/%'
            union select path_name from ".MAIN_DB_PREFIX."doc_directory where path_name like '$dirSuffix%'
            order by path_name";
        $resql = $db->query($sql);
        if ($resql) {
            $dirSuffix = rtrim(get_doc_dir_suffix($directory,false),'/');
            while ($obj = $db->fetch_object($resql)) {
                $pathName = $obj->path_name;
                $wPath1 = str_replace($dirSuffix,'',$pathName);
                $wPath2 = str_replace('\\','/',$wPath1);
                $pathArray = explode('/',$wPath2);
                if ($pathArray[0] != "") {
                    $pathRoot = $pathArray[0];
                } else {
                    $pathRoot = $pathArray[1];
                }
                if (!is_null($pathRoot) && !in_array($pathRoot,$filesLst)) {
                    array_push($filesLst,$pathRoot);
                }
            }
        }
        //
        $return = $filesLst;
    } else {
        if ($funcpref != '@') {
            $return = @scandir($directory, $sorting_order);
        } else {
            $return = scandir($directory, $sorting_order);
        }
    }
    bypass_log($funcpref, "scandir", $prog, "$directory $sorting_order", $return);
    return $return;
}

function md5_file_Bypass($filename, $binary = false, $prog='') {
    return md5_file_Bypass_do('', $prog, $filename, $binary);
}
function md5_file_BypassA($filename, $binary = false, $prog='') {
    return md5_file_Bypass_do('@', $prog, $filename, $binary);
}
function md5_file_Bypass_do($funcpref, $prog, $filename, $binary) {
    global $useByPass;
    if ($useByPass && doc_in_db($filename)) {
        global $db;
        $data = getBlob($filename);
        $return = md5($data,$binary);
    } else {
        if ($funcpref != '@') {
            $return = @md5_file($filename, $binary);
        } else {
            $return = md5_file($filename, $binary);
        }
    }
    bypass_log($funcpref, "md5_file", $prog, "$filename $binary", $return);
    return $return;
}

/*
The following functions are not used in the Dolibarr documents context.
They stay defined and accessible in case of omission. By the way,
a forensic analysis is possible if a trouble occurs.
*/

function fscanf_Bypass($stream, $format, $prog='') {
    $return = fscanf($stream, $format);
    bypass_log('@', "fscanf", $prog, $stream, '');
    return $return;
}
function umask_Bypass($mask = null, $prog='') {
    // umask irrelevant in db context
    $return = umask($mask);
    bypass_log('', "umask", $prog, $mask, $return);
    return $return;
}
function file_get_contents_Bypass($filename, $use_include_path = false, $context = null, $offset = 0, $length = null, $prog='') {
    if ($length){
        $return = file_get_contents($filename, $use_include_path, $context, $offset, $length);
    } else {
        $return = file_get_contents($filename, $use_include_path, $context, $offset);
    }
    $ln = strlen($return);
    bypass_log('', "file_get_contents", $prog, "$filename $ln", '');
    return $return;
}
function file_get_contents_BypassA($filename, $use_include_path = false, $context = null, $offset = 0, $length = null, $prog='') {
    if ($length){
        $return = @file_get_contents($filename, $use_include_path, $context, $offset, $length);
    } else {
        $return = @file_get_contents($filename, $use_include_path, $context, $offset);
    }
    $ln = strlen($return);
    bypass_log('@', "file_get_contents", $prog, "$filename $ln", $return);
    return $return;
}
function rewinddir_Bypass($dir_handle, $prog='') {
    $return = rewinddir($dir_handle);
    bypass_log('', "rewinddir", $prog, $dir_handle, $return);
    return $return;
}
function clearstatcache_Bypass($clear_realpath_cache = false, $filename = "", $prog='') {
    $return = clearstatcache($clear_realpath_cache, $filename);
    bypass_log('', "clearstatcache", $prog, $filename, $return);
    return $return;
}
function disk_free_space_Bypass($directory, $prog='') {
    $return = disk_free_space($directory);
    bypass_log('', "disk_free_space", $prog, $directory, $return);
    return $return;
}
function disk_total_space_Bypass($directory, $prog='') {
    $return = disk_total_space($directory);
    bypass_log('', "disk_total_space", $prog, $directory, $return);
    return $return;
}
function fflush_Bypass($stream, $prog='') {
    $return = fflush($stream);
    bypass_log('', "fflush", $prog, $stream, $return);
    return $return;
}
function fgetc_Bypass($stream, $prog='') {
    $return = fgetc($stream);
    bypass_log('', "fgetc", $prog, $stream, $return);
    return $return;
}
function fgetcsv_Bypass($stream, $length = null, $separator = ",", $enclosure = "\"", $escape = "\\", $eol = "\n", $prog='') {
    $return = fgetcsv($stream, $length, $separator, $enclosure, $escape, $eol);
    bypass_log('', "fgetcsv", $prog, $stream, $return);
    return $return;
}
function fgets_Bypass($stream, $length=null, $prog='') {
    $return = fgets($stream, $length);
    bypass_log('', "fgets", $prog, $stream, $return);
    return $return;
}
function file_put_contents_Bypass($filename, $data, $flags = 0, $prog='') {
    $return = file_put_contents($filename, $data, $flags);
    bypass_log('', "file_put_contents", $prog, $filename, $return);
    return $return;
}
function file_put_contents_BypassA($filename, $data, $flags = 0, $prog='') {
    $return = @file_put_contents($filename, $data, $flags);
    bypass_log('', "file_put_contents", $prog, $filename, $return);
    return $return;
}
function file_Bypass($filename, $flags=0, $prog='') {
    $return = file($filename, $flags);
    bypass_log('', "file", $prog, $filename, $return);
    return $return;
}
function file_BypassA($filename, $flags=0, $prog='') {
    $return = @file($filename, $flags);
    bypass_log('', "@file", $prog, $filename, $return);
    return $return;
}
function filectime_Bypass($filename, $prog='') {
    $return = filectime($filename);
    bypass_log('', "filectime", $prog, $filename, $return);
    return $return;
}
function fileinode_Bypass($filename, $prog='') {
    $return = fileinode($filename);
    bypass_log('', "fileinode", $prog, $filename, $return);
    return $return;
}
function fileperms_Bypass($filename, $prog='') {
    $return = fileperms($filename);
    bypass_log('', "fileperms", $prog, $filename, $return);
    return $return;
}
function flock_Bypass($stream, $operation, $prog='') {
    $return = flock($stream, $operation);
    bypass_log('', "flock", $prog, "$stream $operation", $return);
    return $return;
}
function fputcsv_Bypass($stream, $fields, $separator = ",", $enclosure = "\"", $escape = "\\", $eol = "\n", $prog='') {
    $return = fputcsv($stream, $fields, $separator, $enclosure, $escape, $eol);
    bypass_log('', "fputcsv", $prog, $stream, $return);
    return $return;
}
function fputs_Bypass($stream, $data, $length = null, $prog='') {
    $return = fputs($stream, $data, $length);
    bypass_log('', "fputs", $prog, $stream, $return);
    return $return;
}
function fputs_BypassA($stream, $data, $length = null, $prog='') {
    $return = @fputs($stream, $data, $length);
    bypass_log('', "@fputs", $prog, $stream, $return);
    return $return;
}
function fseek_Bypass($stream, $offset, $whence = SEEK_SET, $prog='') {
    $return = fseek($stream, $offset, $whence);
    bypass_log('', "fseek", $prog, $stream, $return);
    return $return;
}
function fseek_BypassA($stream, $offset, $whence = SEEK_SET, $prog='') {
    $return = @fseek($stream, $offset, $whence);
    bypass_log('', "@fseek", $prog, $stream, $return);
    return $return;
}
function ftell_Bypass($stream, $prog='') {
    $return = ftell($stream);
    bypass_log('', "ftell", $prog, $stream, $return);
    return $return;
}
function ftell_BypassA($stream, $prog='') {
    $return = @ftell($stream);
    bypass_log('', "@ftell", $prog, $stream, $return);
    return $return;
}
function ftruncate_Bypass($stream, $size, $prog='') {
    $return = ftruncate($stream, $size);
    bypass_log('', "ftruncate", $prog, $stream, $return);
    return $return;
}
function is_link_Bypass($filename, $prog='') {
    $return = is_link($filename);
    bypass_log('', "is_link", $prog, $filename, $return);
    return $return;
}
function is_link_BypassA($filename, $prog='') {
    $return = @is_link($filename);
    bypass_log('', "@is_link", $prog, $filename, $return);
    return $return;
}
function rewind_Bypass($stream, $prog='') {
    $return = rewind($stream);
    bypass_log('', "rewind", $prog, $stream, $return);
    return $return;
}
function rewind_BypassA($stream, $prog='') {
    $return = @rewind($stream);
    bypass_log('', "@rewind", $prog, $stream, $return);
    return $return;
}
function symlink_Bypass($target, $link, $prog='') {
    $return = symlink($target, $link);
    bypass_log('', "symlink", $prog, $target, $return);
    return $return;
}
function tempnam_Bypass($directory, $prefix, $prog='') {
    $return = tempnam($directory, $prefix);
    bypass_log('', "tempnam", $prog, $directory, $return);
    return $return;
}
function tempnam_BypassA($directory, $prefix, $prog='') {
    $return = @tempnam($directory, $prefix);
    bypass_log('', "@tempnam", $prog, $directory, $return);
    return $return;
}
function tmpfile_Bypass($prog) {
    $return = tmpfile();
    bypass_log('', "tmpfile", $prog, '', $return);
    return $return;
}
function touch_Bypass($filename, $mtime = null, $atime = null, $prog='') {
    $return = touch($filename, $mtime, $atime);
    bypass_log('', "touch", $prog, $filename, $return);
    return $return;
}
function touch_BypassA($filename, $mtime = null, $atime = null, $prog='') {
    $return = @touch($filename, $mtime, $atime);
    bypass_log('', "@touch", $prog, $filename, $return);
    return $return;
}