<?php
/* Copyright (C) 2021 Catriel Rios <catriel_r@hotmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/**
 * \file    directprintwhb/lib/directprintwhb.lib.php
 * \ingroup directprintwhb
 * \brief   Library files with common functions for DirectPrintWHB
 */

/**
 * Prepare admin pages header
 *
 * @return array
 */
function directprintwhbAdminPrepareHead()
{
	global $langs, $conf;

	$langs->load("directprintwhb@directprintwhb");

	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath("/directprintwhb/admin/setup.php", 1);
	$head[$h][1] = $langs->trans("Settings");
	$head[$h][2] = 'settings';
	$h++;

	/*
	$head[$h][0] = dol_buildpath("/directprintwhb/admin/myobject_extrafields.php", 1);
	$head[$h][1] = $langs->trans("ExtraFields");
	$head[$h][2] = 'myobject_extrafields';
	$h++;
	*/

	$head[$h][0] = dol_buildpath("/directprintwhb/admin/about.php", 1);
	$head[$h][1] = $langs->trans("About");
	$head[$h][2] = 'about';
	$h++;


	$numterminals = max(1, $conf->global->TAKEPOS_NUM_TERMINALS);
	for ($i = 0; $i <= $numterminals; $i++)
	{
		$head[$h][0] = dol_buildpath('/directprintwhb/admin/terminal.php?terminal='.$i,1);
		$head[$h][1] = $langs->trans("Terminal")." ".$i;
		$head[$h][2] = 'terminal'.$i;
		$h++;
	}

	// Show more tabs from modules
	// Entries must be declared in modules descriptor with line
	//$this->tabs = array(
	//	'entity:+tabname:Title:@directprintwhb:/directprintwhb/mypage.php?id=__ID__'
	//); // to add new tab
	//$this->tabs = array(
	//	'entity:-tabname:Title:@directprintwhb:/directprintwhb/mypage.php?id=__ID__'
	//); // to remove a tab
	complete_head_from_modules($conf, $langs, null, $head, $h, 'directprintwhb');

	return $head;
}
